package com.ejie.ab18a.dao;

import java.util.List;

import com.ejie.ab18a.entidades.Ab18aUsuario;
import com.ejie.ab18a.model.Ab18aEnvio;
import com.ejie.ab18a.model.Ab18aFiltroMonitor;
import com.ejie.ab18a.model.Ab18aIncoherencia;
import com.ejie.ab18a.model.Ab18aPeticionDetalle;
import com.ejie.ab18a.model.Ab18aPeticionEnvio;
import com.ejie.ab18a.ws.model.Ab18aDatosRespuestaEsentool;
import com.ejie.ab18a.ws.model.Ab18aValidacionBoletin;
import com.ejie.ab18a.ws.model.DatosBoletin;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab18a01s00Dao generated by XXXX, 03-feb-2017 12:02:31.
 * 
 * @author XXXX
 */

public interface Ab18aPeticionEnvioDao {

	Ab18aPeticionEnvio findIfExists(Ab18aPeticionEnvio peticionAux) throws Exception;

	/**
	 * Inserts a single row in the Ab18a01s00 table.
	 * 
	 * @param peticionEnvio
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 * @throws Exception
	 */
	Ab18aPeticionEnvio add(Ab18aPeticionEnvio peticionEnvio) throws Exception;

	/**
	 * Updates a single row in the Ab18a01s00 table.
	 * 
	 * @param peticionEnvio
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 */
	Ab18aPeticionEnvio update(Ab18aPeticionEnvio peticionEnvio);

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param peticionEnvio
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 */
	Ab18aPeticionEnvio find(Ab18aPeticionEnvio peticionEnvio);

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 */
	DatosBoletin findPeticionRecogida(Ab18aPeticionEnvio ab18a01s00);

	/**
	 * Encuentra registros en la tabla AB18A08T00.
	 * 
	 * @param idPeticionEnvio
	 *            id de la peticion de envio
	 * @return Ab18aDatosRespuestaEsentool
	 */
	List<String> findTedLinks(Integer idPeticionEnvio);

	/**
	 * Finds a list of rows in the Ab18a09s00 table.
	 * 
	 * @param idPeticionEnvio
	 *            id de la peticion de envio
	 * @return Ab18aValidacionBoletin
	 */
	List<Ab18aValidacionBoletin> findValidaciones(Integer idPeticionEnvio);

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param idPeticionEnvio
	 *            id de la peticion de envio
	 * @return Ab18aDatosRespuestaEsentool
	 */
	Ab18aDatosRespuestaEsentool findRespuestaWS(Integer idPeticionEnvio);

	/**
	 * Removes a single row in the Ab18a01s00 table.
	 * 
	 * @param peticionEnvio
	 *            Ab18a01s00
	 */
	void remove(Ab18aPeticionEnvio peticionEnvio);

	/**
	 * Finds a List of rows in the Ab18a01s00 table.
	 * 
	 * @param peticionEnvio
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<Ab18aPeticionEnvio> findAll(Ab18aPeticionEnvio peticionEnvio, JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab18a01s00 table using like.
	 * 
	 * @param peticionEnvio
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Ab18aPeticionEnvio> findAllLike(Ab18aPeticionEnvio peticionEnvio, JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	List<Ab18aEnvio> findPeticionesCuadro(Ab18aFiltroMonitor filtroMonitor, Ab18aUsuario usuario, JQGridRequestDto jqGridRequestDto);

	Long findAllCount(Ab18aFiltroMonitor filtroMonitor, Ab18aUsuario usuario);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Ab18aPeticionEnvio filterPeticionEnvio, JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Ab18a01s00 table using like.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Ab18aPeticionEnvio peticionEnvio, Boolean startsWith);

	/**
	 * Counts rows in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @return Long
	 */
	Long findAllCount(Ab18aPeticionEnvio peticionEnvio);

	/**
	 * Reorder selection.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a01s00>>
	 */
	List<TableRowDto<Ab18aPeticionEnvio>> reorderSelection(Ab18aPeticionEnvio filterPeticionEnvio, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param searchAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a01s00>>
	 */
	List<TableRowDto<Ab18aPeticionEnvio>> search(Ab18aPeticionEnvio filterAb18a01s00, Ab18aPeticionEnvio searchAb18a01s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Ab18a01s00>>
	 */
	List<JerarquiaDto<Ab18aPeticionEnvio>> findAllLikeJerarquia(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto);

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto);

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Ab18a01s00>>
	 */
	List<TableRowDto<Ab18aPeticionEnvio>> findAllChild(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto);

	DatosBoletin findPeticionById(Integer idPeticionEnvio);

	Ab18aPeticionEnvio findZipById(Integer idPeticionEnvio);

	void paralizarReanudarPeticion(Ab18aPeticionEnvio peticion);

	List<Ab18aIncoherencia> findIncoherencias(Ab18aIncoherencia filtroIncoherencia, Ab18aUsuario usuario, JQGridRequestDto jqGridRequestDto);

	Long findAllCountIncoherencias(Ab18aIncoherencia filtroIncoherencias, Ab18aUsuario usuario);

	void deshabilitarIncoherencia(String codExpediente);

	Ab18aPeticionDetalle findDetallePeticionById(Integer idPeticion) throws Exception;

	void reactivar(Integer idPeticion) throws Exception;

	Integer findNumIntentosById(Integer idPeticion) throws Exception;
}
